// Copyright (c) 2020 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "terpsichore/terpsichore_plugin.h"
#include "terpsichore_wasapi/res/resource.h"
#include "terpsichore_wasapi/audio_streamer_wasapi.h"
#include "terpsichore_wasapi/audio_streamer_wasapi_dev.h"
#include "terpsichore_wasapi/audio_streamer_wasapi_prop.h"

#if defined(_WIN32) && defined(_DEBUG)
#include <vld.h>
#endif

#include "WDL/wdlcstring.h"

HINSTANCE wasapi_instance;
static HWND wasapi_main_hwnd;

double (*GetHardwareSampleRate)();
const char *(*GetSettingsPath)();

RST_IAudioStreamer *CreateAudioStreamer()
{
  return new RST_Wasapi;
}

RST_AudioStreamerRegister wasapi_reg =
{
  &CreateAudioStreamer
};

RST_IAudioStreamerDevice *CreateAudioStreamerDevice()
{
  return new RST_WasapiDevice;
}

RST_AudioStreamerDeviceRegister wasapi_dev_reg =
{
  &CreateAudioStreamerDevice
};

RST_IAudioStreamerProperties *CreateAudioStreamerProperties()
{
  return new RST_WasapiProperties;
}

RST_AudioStreamerPropertiesRegister wasapi_prop_reg =
{
  &CreateAudioStreamerProperties
};

extern "C"
{
  TERPSICHORE_PLUGIN_EXPORT int TERPSICHORE_PLUGIN_ENTRYPOINT(
    TERPSICHORE_PLUGIN_HINSTANCE instance, RST_PluginInfo *rec)
  {
    wasapi_instance = instance;

    if (rec)
    {
      if (rec->caller_version != TERPSICHORE_PLUGIN_VERSION || !rec->GetFunc)
      {
        return 0;
      }

      *((void **)&GetSettingsPath) = rec->GetFunc("GetClientSettingsPath");
      *((void **)&GetHardwareSampleRate) = rec->GetFunc("GetHardwareSampleRate");

      wasapi_main_hwnd = rec->hwnd_main;

      if (!GetHardwareSampleRate || !GetSettingsPath || !rec->Register)
      {
        return 0;
      }

      rec->Register("audio_streamer:WASAPI", &wasapi_reg);
      rec->Register("audio_device:WASAPI", &wasapi_dev_reg);
      rec->Register("audio_properties:WASAPI", &wasapi_prop_reg);

      return 1;
    }
    else
    {
      return 0;
    }
  }
}

#ifndef _WIN32
#include <WDL/swell/swell-dlggen.h>
#include <terpsichore_wasapi/res/wasapi.rc_mac_dlg>

#undef BEGIN
#undef END
#include <WDL/swell/swell-menugen.h>
#include <terpsichore_wasapi/res/wasapi.rc_mac_menu>
#endif
