// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_WASAPI_WINDOW_H_
#define _TERPSICHORE_WASAPI_WINDOW_H_

//#include "terpsichore/definitions.h"
#include "terpsichore/terpsichore_plugin.h"
#include "terpsichore/ini_file.h"
#include "terpsichore_wasapi/audio_streamer_wasapi_dev.h"

extern const char *(*GetSettingsPath)();

class RST_WasapiWnd
{
public:
  RST_WasapiWnd();
  ~RST_WasapiWnd();

  HWND Handle() const;

  static WDL_DLGRET ST_WasapiWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

private:
  WDL_DLGRET WasapiWndProc(UINT msg, WPARAM wparam, LPARAM lparam);
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;

  RST_IniFile *m_ini_file;

  RST_WasapiDevice *m_devlist;
};

#endif // _TERPSICHORE_WASAPI_WINDOW_H_
