// Copyright (c) 2020 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "terpsichore/terpsichore_plugin.h"
#include "terpsichore_wave/audio_streamer_pa_wave.h"
#include "terpsichore_wave/audio_streamer_pa_wave_dev.h"
#include "terpsichore_wave/audio_streamer_pa_wave_prop.h"

#if defined(_WIN32) && defined(_DEBUG)
#include <vld.h>
#endif

#include "WDL/wdlcstring.h"

HINSTANCE waveout_instance;
static HWND waveout_main_hwnd;

double (*GetHardwareSampleRate)();
const char *(*GetSettingsPath)();

RST_IAudioStreamer *CreateAudioStreamer()
{
  return new RST_PaWaveOut;
}

RST_AudioStreamerRegister waveout_reg =
{
  &CreateAudioStreamer
};

RST_IAudioStreamerDevice *CreateAudioStreamerDevice()
{
  return new RST_PaWaveOutDevice;
}

RST_AudioStreamerDeviceRegister waveout_dev_reg =
{
  &CreateAudioStreamerDevice
};

RST_IAudioStreamerProperties *CreateAudioStreamerProperties()
{
  return new RST_PaWaveOutProperties;
}

RST_AudioStreamerPropertiesRegister waveout_prop_reg =
{
  &CreateAudioStreamerProperties
};

extern "C"
{
  TERPSICHORE_PLUGIN_EXPORT int TERPSICHORE_PLUGIN_ENTRYPOINT(
    TERPSICHORE_PLUGIN_HINSTANCE instance, RST_PluginInfo *rec)
  {
    waveout_instance = instance;

    if (rec)
    {
      if (rec->caller_version != TERPSICHORE_PLUGIN_VERSION || !rec->GetFunc)
      {
        return 0;
      }

      *((void **)&GetSettingsPath) = rec->GetFunc("GetClientSettingsPath");
      *((void **)&GetHardwareSampleRate) = rec->GetFunc("GetHardwareSampleRate");

      waveout_main_hwnd = rec->hwnd_main;

      if (!GetHardwareSampleRate || !GetSettingsPath || !rec->Register)
      {
        return 0;
      }

      rec->Register("audio_streamer:WaveOut", &waveout_reg);
      rec->Register("audio_device:WaveOut", &waveout_dev_reg);
      rec->Register("audio_properties:WaveOut", &waveout_prop_reg);

      return 1;
    }
    else
    {
      return 0;
    }
  }
}
