// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _TERPSICHORE_WAVEOUT_WINDOW_H_
#define _TERPSICHORE_WAVEOUT_WINDOW_H_

#include "terpsichore/terpsichore_plugin.h"
#include "terpsichore/ini_file.h"
#include "terpsichore_wave/audio_streamer_pa_wave_dev.h"

extern const char *(*GetSettingsPath)();

class RST_WaveOutWnd
{
public:
  RST_WaveOutWnd();
  ~RST_WaveOutWnd();

  HWND Handle() const;

  static WDL_DLGRET ST_WaveOutWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

private:
  WDL_DLGRET WaveOutWndProc(UINT msg, WPARAM wparam, LPARAM lparam);
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;

  RST_IniFile *m_ini_file;

  RST_PaWaveOutDevice *m_devlist;
};

#endif // _TERPSICHORE_WAVEOUT_WINDOW_H_
