#!/bin/sh
#--arch=x86/x86_64 --cpu=i686/generic
#--disable-runtime-cpudetect \
#--enable-libmp3lame \
export CFLAGS=-m64
export CXXFLAGS=-m64
export LDFLAGS=-m64
./configure \
--disable-x86asm \
--arch=x86_64 \
--cpu=generic \
--disable-static \
--enable-shared \
--build-suffix=-terpsichore \
--prefix=./out \
--disable-programs \
--disable-doc \
--disable-avdevice \
--disable-swscale \
--disable-postproc \
--disable-avfilter \
--disable-network \
--disable-dxva2 \
--disable-vaapi \
--disable-vdpau \
--disable-everything \
--disable-iconv \
--disable-debug \
--disable-audiotoolbox \
--disable-cuda \
--disable-cuvid \
--disable-d3d11va \
--disable-dxva2 \
--disable-nvenc \
--disable-vaapi \
--disable-vdpau \
--disable-videotoolbox \
--disable-schannel \
--disable-xlib \
--disable-protocols \
--disable-asm \
--enable-small \
--enable-swresample \
--enable-runtime-cpudetect \
--enable-stripping \
--enable-protocol=file \
--enable-demuxer=flac \
--enable-demuxer=mp3 \
--enable-decoder=flac \
--enable-decoder=mp3 \
--enable-decoder=mp3float \
--enable-parser=flac \
--enable-parser=mpegaudio \
--enable-decoder=bmp \
--enable-decoder=mjpeg \
--enable-decoder=mjpegb \
--enable-decoder=png \
--enable-demuxer=mjpeg \
--enable-encoder=mjpeg \
--enable-encoder=png \
--enable-muxer=mjpeg \
--enable-muxer=singlejpeg \
--enable-parser=bmp \
--enable-parser=mjpeg \
--enable-parser=png

make -j3

mkdir -p ffmpeg-linux-amd64
mkdir -p ffmpeg-linux-amd64/libavcodec
mkdir -p ffmpeg-linux-amd64/libavformat
mkdir -p ffmpeg-linux-amd64/libavutil
mkdir -p ffmpeg-linux-amd64/libswresample

cp libavcodec/*terpsichore.so* ffmpeg-linux-amd64
cp libavutil/*terpsichore.so* ffmpeg-linux-amd64
cp libavformat/*terpsichore.so* ffmpeg-linux-amd64
cp libswresample/*terpsichore.so* ffmpeg-linux-amd64
strip ffmpeg-linux-amd64/*.so*

cp libavcodec/*.h  ffmpeg-linux-amd64/libavcodec/
cp libavformat/*.h ffmpeg-linux-amd64/libavformat/
cp libavutil/*.h ffmpeg-linux-amd64/libavutil/
cp libswresample/*.h ffmpeg-linux-amd64/libswresample/

