rem Retrieve major/minor version
rem ============================

setlocal enabledelayedexpansion

for /f "delims=" %%a in ('findstr /b /c:"#define THA_MAJOR_VERSION " ..\..\src\thalia\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set major_ver="%pwd%"
set maj=%major_ver:~27,1%

for /f "delims=" %%a in ('findstr /b /c:"#define THA_MINOR_VERSION " ..\..\src\thalia\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set minor_ver="%pwd%"
set min=%minor_ver:~27,2%

for /f "delims=" %%a in ('findstr /b /c:"#define THA_RELEASE " ..\..\src\thalia\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set release="%pwd%"
set rel=%release:~22%

rmdir /s /q build
rmdir /s /q src
del /s /q thalia-taglib*.zip

mkdir build
mkdir build\vc
rem mkdir build\linux
mkdir src
mkdir src\WDL-GV
mkdir src\thalia
mkdir src\thalia_taglib
mkdir src\third_party
mkdir src\third_party\taglib

xcopy /y /s ..\..\src\WDL-GV src\WDL-GV
xcopy /y ..\..\src\thalia\thalia_plugin_public.h src\thalia
xcopy /y ..\..\src\thalia\sample_format.h src\thalia
xcopy /y ..\..\build\vc\thalia-taglib.* build\vc
rem xcopy /y ..\..\build\linux\makefile_thalia_taglib.mk build\linux
rem xcopy /y ..\..\build\linux\Makefile build\linux
xcopy /y /s ..\..\src\thalia_taglib src\thalia_taglib
xcopy /y /s ..\..\src\third_party\taglib src\third_party\taglib

7z a -tzip -mx=1 thalia-taglib-%maj%.%min%%rel%-src.zip build
7z a -tzip -mx=1 thalia-taglib-%maj%.%min%%rel%-src.zip src
7z a -tzip -mx=1 thalia-taglib-%maj%.%min%%rel%-src.zip README.txt
7z d -r thalia-taglib-%maj%.%min%%rel%-src.zip build\vc\Win32
7z d -r thalia-taglib-%maj%.%min%%rel%-src.zip build\vc\x64
7z d -r thalia-taglib-%maj%.%min%%rel%-src.zip *.o
7z t thalia-taglib-%maj%.%min%%rel%-src.zip * -r

rmdir /s /q build
rmdir /s /q src

pause
