// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _THA_INFO_H_
#define _THA_INFO_H_

#include <string.h>

#include "thalia/git_sha1.h"

#define THA_MAJOR_VERSION 1
#define THA_MINOR_VERSION 19

#define THA_RELEASE ""
#define THA_SPECIAL ""

#define THA_NAME "thalia"
#define THA_NAME_MARKETING "Thalia"
#define THA_COMPANY_URL "https://www.grafmin.gr/"
#define THA_WEBSITE_URL "https://www.grafmin.gr/thalia"
#define THA_COPYRIGHT "Copyright (c) 2022-2025 Giorgos Vougioukas"

#define THA_STRINGIFY_HELPER(x) #x
#define THA_STRINGIFY(x) THA_STRINGIFY_HELPER(x)

#define THA_NAKED_VERSION \
  THA_STRINGIFY(THA_MAJOR_VERSION) \
  "." THA_STRINGIFY(THA_MINOR_VERSION) \
  THA_RELEASE THA_SPECIAL

#define THA_FULL_VERSION \
  THA_NAME_MARKETING " " THA_NAKED_VERSION

#define THA_GIT_SHA THA_STRINGIFY(GIT_SHA1)

#define THA_TIMESTAMP __DATE__ " " __TIME__

inline bool IsStableRelease()
{
  if (strlen(THA_RELEASE)) return false;

  return true;
}

#if defined(_MSC_VER)
  #if defined(_M_AMD64) || defined(_M_X64)
    #define THA_ARCH "x64"
  #elif defined(_M_IX86)
    #define THA_ARCH "x86"
  #else
    #define THA_ARCH "unk"
  #endif
#elif defined(__linux__) && (defined(__clang__) || defined(__GNUC__))
  #if defined(__amd64__) || defined(__X86_64__)
    #define THA_ARCH "amd64"
  #elif defined(__i386__)
    #define THA_ARCH "i686"
  #else
    #define THA_ARCH "unk"
  #endif
#elif defined(__APPLE__) && (defined(__clang__) || defined(__GNUC__))
  #if defined(__amd64__) || defined(__X86_64__)
    #define THA_ARCH "x86-64"
  #elif defined(__i386__)
    #define THA_ARCH "i386"
  #else
    #define THA_ARCH "unk"
  #endif
#endif

#endif // _THA_INFO_H_
