// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "thalia/artwork_wnd.h"
#include "thalia/preferences.h"
#include "thalia/app_info.h"

#define THA_METADATA_KEY 300200
#define THA_METADATA_VAL 300201

#include "WDL/assocarray.h"

THA_ArtworkWnd::THA_ArtworkWnd()
  : m_hwnd(NULL)
  , m_bm(NULL)
{}

THA_ArtworkWnd::~THA_ArtworkWnd()
{
  delete m_bm;
  DestroyWindow(m_hwnd);
}

void THA_ArtworkWnd::OnInitDialog(WPARAM wparam, LPARAM lparam)
{
  int x = GetPrivateProfileInt(THA_NAME, "artwork_wnd_x", 0, g_inipath.Get());
  int y = GetPrivateProfileInt(THA_NAME, "artwork_wnd_y", 50, g_inipath.Get());
  int w = GetPrivateProfileInt(THA_NAME, "artwork_wnd_w", 600, g_inipath.Get());
  int h = GetPrivateProfileInt(THA_NAME, "artwork_wnd_h", 600, g_inipath.Get());
  SetWindowPos(m_hwnd, NULL, x, y, w, h, SWP_NOZORDER | SWP_NOACTIVATE);

  RECT r;
  GetClientRect(m_hwnd, &r);

  m_bm = new LICE_SysBitmap(r.right - r.left, r.bottom - r.top);
  LICE_Clear(m_bm, LICE_RGBA(0, 0, 0, 255));

  //m_playlist_menu = (HMENU)GetSubMenu(LoadMenu(g_inst, MAKEINTRESOURCE(IDR_LIBRARY_CONTEXT)), 4);
}

void THA_ArtworkWnd::OnPaint(WPARAM wparam, LPARAM lparam)
{
  RECT r;
  GetClientRect(m_hwnd, &r);

  PAINTSTRUCT ps;
  HDC dc = BeginPaint(m_hwnd, &ps);

  if (g_artworkbm)
  {
    LICE_ScaledBlit(m_bm, g_artworkbm, r.left, r.top,
      r.right - r.left, r.bottom - r.top, 0.0f, 0.0f,
      (float)g_artworkbm->getWidth(),
      (float)g_artworkbm->getHeight(), 1.0f,
      LICE_BLIT_MODE_COPY | LICE_BLIT_FILTER_BILINEAR);
  }

  BitBlt(dc, r.left, r.top, r.right - r.left,
    r.bottom - r.top, m_bm->getDC(), 0, 0, SRCCOPY);

  EndPaint(m_hwnd, &ps);
}

void THA_ArtworkWnd::OnTimer(WPARAM wparam, LPARAM lparam)
{}

void THA_ArtworkWnd::OnDestroy(WPARAM wparam, LPARAM lparam)
{
  RECT r;
  GetWindowRect(m_hwnd, &r);

  int x = r.left;
  int y = r.top;
  int w = r.right - r.left;
  int h = r.bottom - r.top;

  WDL_FastString xstr, ystr, wstr, hstr;
  xstr.SetFormatted(32, "%d", x);
  ystr.SetFormatted(32, "%d", y);
  wstr.SetFormatted(32, "%d", w);
  hstr.SetFormatted(32, "%d", h);

  WritePrivateProfileString(THA_NAME, "artwork_wnd_x", xstr.Get(), g_inipath.Get());
  WritePrivateProfileString(THA_NAME, "artwork_wnd_y", ystr.Get(), g_inipath.Get());
  WritePrivateProfileString(THA_NAME, "artwork_wnd_w", wstr.Get(), g_inipath.Get());
  WritePrivateProfileString(THA_NAME, "artwork_wnd_h", hstr.Get(), g_inipath.Get());

  if (g_artworkbm) { delete g_artworkbm; g_artworkbm = NULL; }

  m_hwnd = NULL;
}

void THA_ArtworkWnd::OnSize(WPARAM wparam, LPARAM lparam)
{}

void THA_ArtworkWnd::OnCommand(WPARAM wparam, LPARAM lparam)
{
  switch(LOWORD(wparam))
  {
  case IDOK:
    {
      if (g_artworkwnd) { delete g_artworkwnd; g_artworkwnd = NULL; }
    } break;
  case IDCANCEL:
    {
      if (g_artworkwnd) { delete g_artworkwnd; g_artworkwnd = NULL; }
    } break;
  }
}

void THA_ArtworkWnd::OnSysCommand(WPARAM wparam, LPARAM lparam)
{}

WDL_DLGRET THA_ArtworkWnd::ArtworkWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
  THA_ArtworkWnd *self = (THA_ArtworkWnd *)GetWindowLongPtr(hwnd, GWLP_USERDATA);

  if (!self && msg == WM_INITDIALOG)
  {
    SetWindowLongPtr(hwnd, GWLP_USERDATA, lparam);
    self = (THA_ArtworkWnd *)lparam;
    self->m_hwnd = hwnd;
  }

  if (WDL_likely(self))
  {
    return self->ArtworkWndLoop(msg, wparam, lparam);
  }
  else
  {
    return 0;
  }
}

WDL_DLGRET THA_ArtworkWnd::ArtworkWndLoop(UINT msg, WPARAM wparam, LPARAM lparam)
{
  switch (msg)
  {
    case WM_INITDIALOG: OnInitDialog(wparam, lparam); break;
    case WM_PAINT: OnPaint(wparam, lparam); break;
    case WM_TIMER: OnTimer(wparam, lparam); break;
    case WM_DESTROY: OnDestroy(wparam, lparam); break;
    case WM_SIZE: OnSize(wparam, lparam); break;
    case WM_COMMAND: OnCommand(wparam, lparam); break;
    case WM_SYSCOMMAND: OnSysCommand(wparam, lparam); break;
  }

  return 0;
}
