// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _THALIA_ARTWORK_WND_H_
#define _THALIA_ARTWORK_WND_H_

#include "thalia/definitions.h"

#include "WDL/lice/lice.h"
#include "WDL/wingui/wndsize.h"
#include "WDL/wdlstring.h"

class THA_ArtworkWnd
{
public:
  THA_ArtworkWnd();
  ~THA_ArtworkWnd();

  HWND Handle() const { return m_hwnd; }

  static WDL_DLGRET ArtworkWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnPaint(WPARAM wparam, LPARAM lparam);
  void OnTimer(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);
  void OnSysCommand(WPARAM wparam, LPARAM lparam);
  WDL_DLGRET ArtworkWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;

  LICE_IBitmap *m_bm;
};

#endif // _THALIA_ARTWORK_WND_H_
