// Copyright (c) 2017 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _THA_BUFFER_QUEUE_H_
#define _THA_BUFFER_QUEUE_H_

#include <stdlib.h>
#include <string.h>

#include "thalia/sample_format.h"

#include "WDL/heapbuf.h"
#include "WDL/ptrlist.h"
#include "WDL/queue.h"
#include "WDL/mutex.h"

struct BQ_Block
{
  WDL_TypedQueue<SAM> samq;
  double time;
};

class THA_BufferQueue
{
public:
  THA_BufferQueue();
  ~THA_BufferQueue();

  void AddBlock(WDL_TypedBuf<SAM> *block, double time);
  bool GetBlock(BQ_Block **block);
  void ReturnBlock(BQ_Block *block);
  void DisposeBlock(BQ_Block *block);
  int GetSize() const;
  void Flush();
  void Empty();

private:
  WDL_PtrList<BQ_Block> m_blocks;
  WDL_PtrList<BQ_Block> m_empty_blocks;
  WDL_Mutex m_mutex;
  int m_size_bytes;
};

#endif // _THA_BUFFER_QUEUE_H_
