// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _THA_CHANGELOG_WND_H_
#define _THA_CHANGELOG_WND_H_

#include "thalia/definitions.h"
#include "thalia/editor.h"
#include "thalia/app_info.h"

#include "WDL/wingui/wndsize.h"

class THA_ChangelogWnd
{
public:
  THA_ChangelogWnd();
  ~THA_ChangelogWnd();

  HWND Handle() const { return m_hwnd; }
  static WDL_DLGRET ChangelogWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnTimer(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);
  void OnSysCommand(WPARAM wparam, LPARAM lparam);
  WDL_DLGRET ChangelogWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;

  WDL_WndSizer m_resize;
  THA_PreviewEditor m_preview;
};

#endif // _THA_CHANGELOG_WND_H_
