// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "thalia/definitions.h"
#include "thalia/render_system.h"
#include "thalia/about_wnd.h"
#include "thalia/changelog_wnd.h"
#include "thalia/license_wnd.h"
#include "thalia/main_wnd.h"
#include "thalia/preferences_wnd.h"
#include "thalia/preferences.h"
#include "thalia/database.h"
#include "thalia/playlist.h"
#include "thalia/query.h"
#include "thalia/playlist_wnd.h"
#include "thalia/metadata_queue.h"
#include "thalia/metadata_wnd.h"
#include "thalia/artwork_wnd.h"

#include "WDL/lice/lice.h"

//#include "thalia/thalia_plugin.h"

static void free_str(const char *p) { free((void *)p); }

HINSTANCE g_inst = NULL;
UINT g_scrollmessage;
bool g_hasrequestedquit = false;

WDL_FastString g_modpath;
WDL_FastString g_setpath;
WDL_FastString g_inipath;
WDL_FastString g_media_ext(".flac .mp3 .ogg .wv .wav .aiff .opus");

THA_RenderSystem *g_rendersystem = NULL;
THA_IAudioStreamer *g_audiostreamer = NULL;
THA_Database *g_database = NULL;
THA_Query *g_query = NULL;
THA_Preferences *g_preferences = NULL;
THA_PlayList *g_playlist = NULL;
THA_MetadataQueue *g_metadataqueue = NULL;
LICE_IBitmap *g_artworkbm = NULL;

THA_MainWnd *g_mainwnd = NULL;
THA_LicenseWnd *g_licwnd = NULL;
THA_ChangelogWnd *g_changelogwnd = NULL;
THA_PreferencesWnd *g_prefwnd = NULL;
THA_AboutWnd *g_aboutwnd = NULL;
THA_SavePlayListWnd *g_saveplwnd = NULL;
THA_LoadPlayListWnd *g_loadplwnd = NULL;
THA_EditPlayListsWnd *g_editplwnd = NULL;
THA_MetadataWnd *g_metadatawnd = NULL;
THA_ArtworkWnd *g_artworkwnd = NULL;
THA_FileInfoWnd *g_fileinfownd = NULL;
HWND g_indexwnd = NULL;
HWND g_movewnd = NULL;
HWND g_urlwnd = NULL;

WDL_PtrKeyedArray<const char *> g_pluginimport(free_str);
WDL_StringKeyedArray<void *> g_pluginexport;

void THA_AudioOnSamples(WDL_TypedBuf<SAM> *output, int frame_count, int nch)
{
  g_rendersystem->AudioStreamerData(output, frame_count, nch);
}

double THA_GetAudioDeviceSamplerate() { return g_preferences->GetAudioDeviceSamplerate(); }
int THA_GetAudioDeviceBitDepth() { return g_preferences->GetAudioDeviceBitDepth(); }
int THA_GetAudioDeviceOutputChannels() { return g_preferences->GetAudioDeviceOutputChannels(); }

void THA_GetDiskReadMode(int *rmode, int *rbufsize, int *rnbufs)
{
  g_preferences->GetDiskReadMode(rmode, rbufsize, rnbufs);
}

void THA_GetDiskWriteMode(int *wmode, int *wbufsize, int *wminbufs, int *wmaxbufs)
{
  g_preferences->GetDiskWriteMode(wmode, wbufsize, wminbufs, wmaxbufs);
}

int THA_GetDiskIOPriority() { return g_preferences->GetDiskIOPriority(); }
int THA_GetDiskIOSleepStep() { return g_preferences->GetDiskIOSleepStep(); }
int THA_GetAntidoteBitDepth() { return g_preferences->GetAntidoteBitDepth(); }
int THA_GetAudioSystem() { return g_preferences->GetAudioSystem(); }

void THA_GetResampleMode(bool *interp, int *filtercnt,
  bool *sinc, int *sinc_size, int *sinc_interpsize)
{
  g_preferences->GetResampleMode(interp, filtercnt, sinc, sinc_size, sinc_interpsize);
}

bool THA_GetWASAPIExclusiveMode() { return g_preferences->GetWASAPIExclusiveMode(); }
