// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _THA_DEFINITIONS_H_
#define _THA_DEFINITIONS_H_

#if defined(_WIN32)
#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#include <process.h>
#else
#include "WDL/swell/swell.h"
#include "WDL/swell/swell-functions.h"
#endif

#include "thalia/res/resource.h"
#include "thalia/sample_format.h"

#include "WDL/wdltypes.h"
#include "WDL/win32_utf8.h"
#include "WDL/heapbuf.h"
#include "WDL/ptrlist.h"
#include "WDL/wdlstring.h"
#include "WDL/assocarray.h"

class THA_RenderSystem;
class THA_IAudioStreamer;
class THA_AboutWnd;
class THA_ChangelogWnd;
class THA_LicenseWnd;
class THA_MainWnd;
class THA_PreferencesWnd;
class THA_Database;
class THA_Query;
class THA_Preferences;
class THA_PlayList;
class THA_SavePlayListWnd;
class THA_LoadPlayListWnd;
class THA_EditPlayListsWnd;
class THA_MetadataQueue;
class THA_MetadataWnd;
class THA_ArtworkWnd;
class LICE_IBitmap;
class THA_FileInfoWnd;

extern HINSTANCE g_inst;
extern UINT g_scrollmessage;
extern bool g_hasrequestedquit;

extern WDL_FastString g_modpath;
extern WDL_FastString g_setpath;
extern WDL_FastString g_inipath;
extern WDL_FastString g_media_ext;

extern THA_RenderSystem *g_rendersystem;
extern THA_IAudioStreamer *g_audiostreamer;
extern THA_Database *g_database;
extern THA_Query *g_query;
extern THA_Preferences *g_preferences;
extern THA_PlayList *g_playlist;
extern THA_MetadataQueue *g_metadataqueue;
extern LICE_IBitmap *g_artworkbm;

extern THA_MainWnd *g_mainwnd;
extern THA_LicenseWnd *g_licwnd;
extern THA_ChangelogWnd *g_changelogwnd;
extern THA_PreferencesWnd *g_prefwnd;
extern THA_AboutWnd *g_aboutwnd;
extern THA_SavePlayListWnd *g_saveplwnd;
extern THA_LoadPlayListWnd *g_loadplwnd;
extern THA_EditPlayListsWnd *g_editplwnd;
extern THA_MetadataWnd *g_metadatawnd;
extern THA_ArtworkWnd *g_artworkwnd;
extern THA_FileInfoWnd *g_fileinfownd;
extern HWND g_indexwnd;
extern HWND g_movewnd;
extern HWND g_urlwnd;

extern WDL_PtrKeyedArray<const char *> g_pluginimport;
extern WDL_StringKeyedArray<void *> g_pluginexport;

extern WDL_DLGRET THA_GotoIndexWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
extern WDL_DLGRET THA_MoveToIndexWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
extern WDL_DLGRET THA_AddURLWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

extern void THA_RunMessageLoop();
extern int THA_ProcessMessage(MSG *msg);
extern void THA_AudioOnSamples(WDL_TypedBuf<SAM> *output, int frame_count, int nch);

extern double THA_GetAudioDeviceSamplerate();
extern int THA_GetAudioDeviceBitDepth();
extern int THA_GetAudioDeviceOutputChannels();
extern void THA_GetDiskReadMode(int *rmode, int *rbufsize, int *rnbufs);
extern void THA_GetDiskWriteMode(int *wmode, int *wbufsize, int *wminbufs, int *wmaxbufs);
extern int THA_GetDiskIOPriority();
extern int THA_GetDiskIOSleepStep();
extern int THA_GetAntidoteBitDepth();
extern int THA_GetAudioSystem();
extern void THA_GetResampleMode(bool *interp, int *filtercnt,
  bool *sinc, int *sinc_size, int *sinc_interpsize);
extern bool THA_GetWASAPIExclusiveMode();

#endif // _THA_DEFINITIONS_H_
