// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _THA_MAIN_WND_H_
#define _THA_MAIN_WND_H_

#include "thalia/definitions.h"

#include "WDL/wingui/wndsize.h"
#include "WDL/wingui/virtwnd.h"
#include "WDL/wingui/virtwnd-controls.h"
#include "WDL/lineparse.h"
#include "WDL/mutex.h"
#include "WDL/aggarray.h"

class THA_MainWnd
{
public:
  THA_MainWnd();
  ~THA_MainWnd();

  HWND Handle() const { return m_hwnd; }

  void Search();
  void MoveUp();
  void MoveDown();
  void RemoveSelected();
  void CropSelected();
  void Sort(int subitem, bool reverse, bool selected);
  void ReverseSelected();
  void RandomizeSelected();
  void SelectAll();
  void SelectNone();
  void InvertSelection();
  void DeleteAll();
  void OpenFileLocation();
  void Cut();
  void Copy();
  void Paste();
  void DatabaseCopy();
  void DatabaseOpenFileLocation();
  void StartPlayback();
  void StopPlayback();
  void FocusTrack();
  void FocusPlayList();
  void Refresh();
  void ToggleTime();
  void RemoveMissingFiles();
  void RemoveDuplicateFiles();
  void PlayListFind(bool enable);
  bool IsPlayListFind() const;
  void Find();
  void GotoIndex();
  void GotoIndex(int index);
  void MoveToIndex();
  void MoveToIndex(int index);
  void HideEditLabel();
  void ShowEditLabel();
  void SetInfo(const char *info);
  void SetTitle(const char *title);
  const char *GetOrigTitle() const;
  void AddURL(const char *url);
  void SetSelection(int start, int end);
  void Metadata();
  void Artwork();
  void FileInfo();
  int GetHeaderSubitem(int id) const;

  static WDL_DLGRET MainWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void ApplySelection();
  void UpdateIndexes();
  void ScanFiles(const char *path, bool empty_file_cache = true);
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnSysCommand(WPARAM wparam, LPARAM lparam);
  INT_PTR OnClose(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnMove(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);
  void OnTimer(WPARAM wparam, LPARAM lparam);
  void OnPaint(WPARAM wparam, LPARAM lparam);
  INT_PTR OnNotify(WPARAM wparam, LPARAM lparam);
  void OnContextMenu(WPARAM wparam, LPARAM lparam);
  void OnLButtonDown(WPARAM wparam, LPARAM lparam);
  void OnLButtonUp(WPARAM wparam, LPARAM lparam);
  void OnMouseMove(WPARAM wparam, LPARAM lparam);
  INT_PTR OnCtrlColorEdit(UINT msg, WPARAM wparam, LPARAM lparam);
  void OnActivateApp(WPARAM wparam, LPARAM lparam);
  void OnNCLButtonDown(WPARAM wparam, LPARAM lparam);
  WDL_DLGRET MainWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);
  static WDL_DLGRET NewTreeProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
  static WDL_DLGRET NewListProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
  static WDL_DLGRET NewEditProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

  static int sort_by_file_path(const void *a, const void *b)
  {
    WDL_FastString *s1, *s2;
    s1 = *(WDL_FastString **)a;
    s2 = *(WDL_FastString **)b;
    return stricmp(s1->Get(), s2->Get());
  }

  HWND m_hwnd;

  int m_x, m_y, m_w, m_h;
  WDL_WndSizer m_resize;
  HMENU m_main_menu;
  WDL_VirtualWnd_Painter m_painter;

  TV_INSERTSTRUCT m_tvinsert;
  HWND m_tree;
  HTREEITEM m_item;
  HWND m_list;
  HWND m_edit;
  WDL_VirtualStaticText *m_editlabel;
  WDL_TypedArray<char, 2048> m_text;
  WDL_FastString m_strbuf;

  struct ColumnHeader
  {
    int id;
    const char *text;
    int width;
    int fmt;
    int sort_dir; // 1 ascending, -1 descending
    int sort_type; // 0 text, 1 numeric
  };

  WDL_TypedBuf<ColumnHeader> m_column_header;
  HMENU m_column_menu;
  HMENU m_database_menu;
  HMENU m_playlist_menu;
  HMENU m_time_menu;
  bool m_lv_drag;
  int m_dragitem;
  int m_selstart;
  int m_selend;
  WDL_TypedBuf<int> m_sel;
  int m_activesel;
  bool m_splitter;
  bool m_scandb;

  WDL_VWnd m_vwnd;
  WDL_VirtualStaticText *m_time;
  WDL_VirtualStaticText *m_info;
  LICE_IFont *m_font;
  bool m_timestate;
  HBRUSH m_brush;

  bool m_playlistfind;
  int m_marquee;
  WDL_FastString m_titleorig;

  LineParser m_lp;
  WDL_PtrList<WDL_FastString> m_file_cache;
  bool m_titlecapture;
};

#endif // _THA_MAIN_WND_H_
