// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _THALIA_METADATA_QUEUE_H_
#define _THALIA_METADATA_QUEUE_H_

#include "thalia/definitions.h"

#include "WDL/assocarray.h"
#include "WDL/wdlstring.h"
#include "WDL/ptrlist.h"
#include "WDL/mutex.h"

class THA_MetadataQueue
{
public:
  THA_MetadataQueue();
  ~THA_MetadataQueue();

  void AddFile(const char *filepath);
  int GetFilePathCount() const;
  bool HasFilesInQueue() const;

  void GetMetadata(WDL_StringKeyedArray<WDL_FastString *> **metadata);
  void UpdateMetadata(const char *key, const char *val);

  void Save();
  void Abort();
private:
  void StartThread();
  void StopThread();
  void Finalize();
  static unsigned int WINAPI ThreadFunction(void *arg);
  int Run();

  struct ThreadDetails
  {
    unsigned int id;
    HANDLE thread;
  };

  WDL_TypedBuf<ThreadDetails> m_threads;
  bool m_killthread;
  WDL_Mutex m_mutex;

  WDL_PtrList<WDL_FastString> m_filepaths;
  WDL_PtrList<WDL_FastString> m_queuedfilepaths;
  WDL_StringKeyedArray<WDL_FastString *> m_metadata;
  bool m_save;
  WDL_FastString m_strbuf;
};

#endif // _THALIA_METADATA_QUEUE_H_
