// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _THALIA_METADATA_WND_H_
#define _THALIA_METADATA_WND_H_

#include "thalia/definitions.h"

#include "WDL/wingui/wndsize.h"
#include "WDL/wdlstring.h"

class THA_MetadataWnd
{
public:
  THA_MetadataWnd();
  ~THA_MetadataWnd();

  HWND Handle() const { return m_hwnd; }

  void Edit();
  HWND GetEdit() const;
  void EditConfirm();
  void EditAbort();

  static WDL_DLGRET MetadataWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnTimer(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);
  void OnSysCommand(WPARAM wparam, LPARAM lparam);
  WDL_DLGRET MetadataWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  WDL_WndSizer m_resize;

  HWND m_list;
  HWND m_edit;

  struct ColumnHeader
  {
    int id;
    const char *text;
    int width;
    int fmt;
    int sort_dir; // 1 ascending, -1 descending
    int sort_type; // 0 text, 1 numeric
  };

  WDL_TypedBuf<ColumnHeader> m_column_header;
  WDL_FastString m_strbuf;
};

class THA_FileInfoWnd
{
public:
  THA_FileInfoWnd();
  ~THA_FileInfoWnd();

  HWND Handle() const { return m_hwnd; }

  void Edit();
  HWND GetEdit() const;
  void EditConfirm();
  void EditAbort();

  static WDL_DLGRET FileInfoWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnTimer(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);
  void OnSysCommand(WPARAM wparam, LPARAM lparam);
  WDL_DLGRET FileInfoWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  WDL_WndSizer m_resize;

  HWND m_list;
  HWND m_edit;

  struct ColumnHeader
  {
    int id;
    const char *text;
    int width;
    int fmt;
    int sort_dir; // 1 ascending, -1 descending
    int sort_type; // 0 text, 1 numeric
  };

  WDL_TypedBuf<ColumnHeader> m_column_header;
  WDL_FastString m_strbuf;
};

#endif // _THALIA_METADATA_WND_H_
