// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "thalia/definitions.h"
#include "thalia/render_system.h"
#include "thalia/about_wnd.h"
#include "thalia/changelog_wnd.h"
#include "thalia/license_wnd.h"
#include "thalia/main_wnd.h"
#include "thalia/preferences_wnd.h"
#include "thalia/preferences.h"
#include "thalia/playlist_wnd.h"
#include "thalia/metadata_wnd.h"

// VK_OEM_1: semicolon (0xBA)
// VK_OEM_2: slash (0xBF)
// VK_OEM_3: tilde (0xC0)
// VK_OEM_4: left bracket (0xDB)
// VK_OEM_5: backslash (0xDC)
// VK_OEM_6: right bracket (0xDD)
// VK_OEM_7: quote (0xDE)
// VK_OEM_PLUS: equal (0xBB)
// VK_OEM_MINUS: dash (0xBD)
// VK_OEM_COMMA: comma (0xBC)
// VK_OEM_PERIOD: period (0xBE)

int THA_ProcessMessage(MSG *msg)
{
  if (g_metadatawnd && (msg->hwnd == g_metadatawnd->Handle() || IsChild(g_metadatawnd->Handle(), msg->hwnd)))
  {
    if (GetFocus() == GetDlgItem(g_metadatawnd->Handle(), IDC_LIST1))
    {
      if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN /* || msg->message == WM_CHAR */)
      {
        if (msg->lParam & FVIRTKEY)
        {
          if (msg->wParam == VK_F2)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                g_metadatawnd->Edit();
              }

              return 1;
            }
          }
        } // FVIRTKEY
      }
    }
    if (GetFocus() == g_metadatawnd->GetEdit())
    {
      if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN /* || msg->message == WM_CHAR */)
      {
        if (msg->lParam & FVIRTKEY)
        {
          if (msg->wParam == VK_RETURN)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                g_metadatawnd->EditConfirm();
              }

              return 1;
            }
          }
          if (msg->wParam == VK_ESCAPE)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                g_metadatawnd->EditAbort();
              }

              return 1;
            }
          }
        }
      }
    }
    else
    {
      if (g_metadatawnd->GetEdit()) g_metadatawnd->EditAbort();
    }
  }

  if (g_fileinfownd && (msg->hwnd == g_fileinfownd->Handle() || IsChild(g_fileinfownd->Handle(), msg->hwnd)))
  {
    if (GetFocus() == GetDlgItem(g_fileinfownd->Handle(), IDC_LIST1))
    {
      if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN /* || msg->message == WM_CHAR */)
      {
        if (msg->lParam & FVIRTKEY)
        {
          if (msg->wParam == VK_F2)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                g_fileinfownd->Edit();
              }

              return 1;
            }
          }
        } // FVIRTKEY
      }
    }
    if (GetFocus() == g_fileinfownd->GetEdit())
    {
      if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN /* || msg->message == WM_CHAR */)
      {
        if (msg->lParam & FVIRTKEY)
        {
          if (msg->wParam == VK_RETURN)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                g_fileinfownd->EditConfirm();
              }

              return 1;
            }
          }
          if (msg->wParam == VK_ESCAPE)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                g_fileinfownd->EditAbort();
              }

              return 1;
            }
          }
        }
      }
    }
    else
    {
      if (g_fileinfownd->GetEdit()) g_fileinfownd->EditAbort();
    }
  }

  if (g_editplwnd && (msg->hwnd == g_editplwnd->Handle() || IsChild(g_editplwnd->Handle(), msg->hwnd)))
  {
    if (GetFocus() == GetDlgItem(g_editplwnd->Handle(), IDC_LIST1))
    {
      if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN /* || msg->message == WM_CHAR */)
      {
        if (msg->lParam & FVIRTKEY)
        {
          if (msg->wParam == VK_F2)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                g_editplwnd->Rename();
              }

              return 1;
            }
          }
          if (msg->wParam == VK_DELETE)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                g_editplwnd->Delete();
              }

              return 1;
            }
          }
        } // FVIRTKEY
      }
    }
    if (GetFocus() == g_editplwnd->GetRename())
    {
      if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN /* || msg->message == WM_CHAR */)
      {
        if (msg->lParam & FVIRTKEY)
        {
          if (msg->wParam == VK_RETURN)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                g_editplwnd->RenameConfirm();
              }

              return 1;
            }
          }
          if (msg->wParam == VK_ESCAPE)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                g_editplwnd->RenameAbort();
              }

              return 1;
            }
          }
        }
      }
    }
    else
    {
      if (g_editplwnd->GetRename()) g_editplwnd->RenameAbort();
    }
  }

  if (g_loadplwnd && (msg->hwnd == g_loadplwnd->Handle() || IsChild(g_loadplwnd->Handle(), msg->hwnd)))
  {
    if (GetFocus() == GetDlgItem(g_loadplwnd->Handle(), IDC_TREE1))
    {
      if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN /* || msg->message == WM_CHAR */)
      {
        if (msg->lParam & FVIRTKEY)
        {
          if (msg->wParam == VK_RETURN)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                SendMessage(g_loadplwnd->Handle(), WM_COMMAND, ID_DATABASE_ADDTOPLAYLIST, 0);
              }

              return 1;
            }
          }
          if (msg->wParam == VK_RETURN)
          {
            if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                SendMessage(g_loadplwnd->Handle(), WM_COMMAND, ID_DATABASE_ADDTONEWPLAYLIST, 0);
              }

              return 1;
            }
          }
        } // FVIRTKEY

        if (msg->wParam == 'C')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_loadplwnd->Handle(), WM_COMMAND, ID_DATABASE_COPY, 0);
            }

            return 1;
          }
        }
      }
    }
  }

  if (g_mainwnd && (msg->hwnd == g_mainwnd->Handle() || IsChild(g_mainwnd->Handle(), msg->hwnd)))
  {
    if (msg->wParam == VK_CONTROL &&
        (msg->message == WM_KEYDOWN ||
          msg->message == WM_KEYUP))
    {
      if (GetCapture() == g_mainwnd->Handle())
      {
        //InvalidateRect(g_mainwnd->Handle(), NULL, FALSE);
      }
    }

    //if (msg->message == WM_MOUSEWHEEL)
    //{
    //  SendMessage(msg->hwnd, WM_MOUSEWHEEL, msg->wParam, msg->lParam);

    //  return 1;
    //}

    if (GetFocus() == GetDlgItem(g_mainwnd->Handle(), IDC_EDIT1))
    {
      if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN /* || msg->message == WM_CHAR */)
      {
        if (msg->lParam & FVIRTKEY)
        {
          if (msg->wParam == VK_RETURN)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                if (g_mainwnd->IsPlayListFind())
                {
                  g_mainwnd->Find();
                }
                else
                {
                  g_mainwnd->Search();
                }
              }

              return 1;
            }
            if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                if (g_mainwnd->IsPlayListFind())
                {
                  HWND list = GetDlgItem(g_mainwnd->Handle(), IDC_LIST1);
                  HWND edit = GetDlgItem(g_mainwnd->Handle(), IDC_EDIT1);
                  SetWindowText(edit, "");
                  SetFocus(list);
                }
              }

              return 1;
            }
          }
        } // FVIRTKEY

        if (msg->wParam == 'D')
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            (GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              HWND edt = GetDlgItem(g_mainwnd->Handle(), IDC_EDIT1);
              SendMessage(edt, EM_SETSEL, 0, -1);
              SetFocus(edt);
            }

            return 1;
          }
        }
        if (msg->wParam == 'D')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->PlayListFind(false);
              HWND edt = GetDlgItem(g_mainwnd->Handle(), IDC_EDIT1);
              SetWindowText(edt, "");
              g_mainwnd->Search();
              SetFocus(edt);
            }

            return 1;
          }
        }
        if (msg->wParam == 'F')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->PlayListFind(true);
              HWND edt = GetDlgItem(g_mainwnd->Handle(), IDC_EDIT1);
              SetWindowText(edt, "");
              g_mainwnd->Find();
              SetFocus(edt);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_OEM_PERIOD)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {}

            return 0;
          }
        }
      }
    }

    if (GetFocus() == GetDlgItem(g_mainwnd->Handle(), IDC_TREE1))
    {
      if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN /* || msg->message == WM_CHAR */)
      {
        if (msg->lParam & FVIRTKEY)
        {
          if (msg->wParam == VK_RETURN)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_DATABASE_ADDTOPLAYLIST, 0);
              }

              return 1;
            }
          }
          if (msg->wParam == VK_RETURN)
          {
            if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_DATABASE_ADDTONEWPLAYLIST, 0);
              }

              return 1;
            }
          }
        } // FVIRTKEY

        if (msg->wParam == 'C')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_DATABASE_COPY, 0);
            }

            return 1;
          }
        }
      }
    }

    if (GetFocus() == GetDlgItem(g_mainwnd->Handle(), IDC_LIST1))
    {
      if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN /* || msg->message == WM_CHAR */)
      {
        if (msg->lParam & FVIRTKEY)
        {
          if (msg->wParam == VK_UP)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              (GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                g_mainwnd->MoveUp();
              }

              return 1;
            }
          }
          if (msg->wParam == VK_DOWN)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              (GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                g_mainwnd->MoveDown();
              }

              return 1;
            }
          }
          if (msg->wParam == VK_DELETE)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                g_mainwnd->RemoveSelected();
              }

              return 1;
            }
          }
          if (msg->wParam == VK_DELETE)
          {
            if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                g_mainwnd->CropSelected();
              }

              return 1;
            }
          }
          if (msg->wParam == VK_DELETE)
          {
            if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                g_mainwnd->DeleteAll();
              }

              return 1;
            }
          }
          if (msg->wParam == VK_RETURN)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                g_mainwnd->StartPlayback();
              }

              return 1;
            }
          }
          if (msg->wParam == VK_OEM_2)
          {
            if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) ||
              (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                int nit = 0;
                HWND list = GetDlgItem(g_mainwnd->Handle(), IDC_LIST1);
                int pos = ListView_GetNextItem(list, -1, LVIS_SELECTED);
                while (pos != -1)
                {
                  nit++;
                  pos = ListView_GetNextItem(list, pos, LVIS_SELECTED);
                }

                if (nit)
                {
                  WDL_FastString strbuf;
                  if (nit == 1)
                  {
                    strbuf.SetFormatted(512, "%s | %d item selected",
                      g_mainwnd->GetOrigTitle(), nit);
                  }
                  else
                  {
                    strbuf.SetFormatted(512, "%s | %d items selected",
                      g_mainwnd->GetOrigTitle(), nit);
                  }
                  g_mainwnd->SetTitle(strbuf.Get());
                }
              }

              return 1;
            }
          }
        } // FVIRTKEY

        if (msg->wParam == 'H')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_PLAYLIST_LENGTH, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == 'E')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_PLAYLIST_METADATA, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == 'B')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_PLAYLIST_ARTWORK, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == 'I')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_PLAYLIST_FILEINFO, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == 'M')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->MoveToIndex();
            }

            return 1;
          }
        }
        if (msg->wParam == '1')
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            (GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_COPYPROPERTY_TITLE, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == '2')
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            (GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_COPYPROPERTY_ARTIST, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == '3')
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            (GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_COPYPROPERTY_ALBUM, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == '4')
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            (GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_COPYPROPERTY_FILENAME, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == '5')
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            (GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_COPYPROPERTY_FILEPATH, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == '1')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_SORT_TITLE, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == '2')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_SORT_ARTIST, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == '3')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_SORT_ALBUM, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == '4')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_SORT_FILENAME, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == '5')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_SORT_FILEPATH, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == '1')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_SORT_TITLEREVERSE, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == '2')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_SORT_ARTISTREVERSE, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == '3')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_SORT_ALBUMREVERSE, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == '4')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_SORT_FILENAMEREVERSE, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == '5')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_SORT_FILEPATHREVERSE, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == 'D')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->RemoveDuplicateFiles();
            }

            return 1;
          }
        }
        if (msg->wParam == 'M')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->RemoveMissingFiles();
            }

            return 1;
          }
        }
        if (msg->wParam == 'R')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->ReverseSelected();
            }

            return 1;
          }
        }
        if (msg->wParam == 'R')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->RandomizeSelected();
            }

            return 1;
          }
        }
        if (msg->wParam == 'X')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_PLAYLIST_CUT, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == 'C')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_PLAYLIST_COPY, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == 'V')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_PLAYLIST_PASTE, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == 'A')
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->SelectAll();
            }

            return 1;
          }
        }
      }
    }

    if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN /* || msg->message == WM_CHAR */)
    {
      if (msg->lParam & FVIRTKEY)
      {
        if (msg->wParam == VK_F1)
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_HELP_ABOUT, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F2)
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_HELP_CHANGELOG, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F3)
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_HELP_VERSION, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F5)
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->Refresh();
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F9)
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_OPTIONS_SCANMEDIALIBRARYPATHS, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_OEM_PERIOD)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->StopPlayback();
            }

            return 1;
          }
        }
        if (msg->wParam == VK_OEM_MINUS)
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              double vol = g_rendersystem->GetVolume();
              vol -= g_preferences->GetVolumeStep();
              vol = wdl_clamp(vol, -150.0, 0.0);
              g_rendersystem->SetVolume(vol);
              WDL_FastString str;
              str.SetFormatted(512, "%.2fdB", vol);
              g_mainwnd->SetInfo(str.Get());
            }

            return 1;
          }
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->SetVolume(-150.0);
              WDL_FastString str;
              str.SetFormatted(512, "%.2fdB", -150.0);
              g_mainwnd->SetInfo(str.Get());
            }

            return 1;
          }
        }
        if (msg->wParam == VK_OEM_PLUS)
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              double vol = g_rendersystem->GetVolume();
              vol += g_preferences->GetVolumeStep();
              vol = wdl_clamp(vol, -150.0, 0.0);
              g_rendersystem->SetVolume(vol);
              WDL_FastString str;
              str.SetFormatted(512, "%.2fdB", vol);
              g_mainwnd->SetInfo(str.Get());
            }

            return 1;
          }
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_rendersystem->SetVolume(0.0);
              WDL_FastString str;
              str.SetFormatted(512, "%.2fdB", 0.0);
              g_mainwnd->SetInfo(str.Get());
            }

            return 1;
          }
        }
      } // FVIRTKEY

      if (msg->wParam == 'U')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_ADDURL, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'N')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->SelectNone();
          }

          return 1;
        }
      }
      if (msg->wParam == 'I')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->InvertSelection();
          }

          return 1;
        }
      }
      if (msg->wParam == 'F')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_ADDFILES, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'O')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_ADDFOLDER, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'S')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_SAVEPLAYLIST, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'A')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_LOADPLAYLIST, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'E')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_EDITPLAYLISTS, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'G')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->GotoIndex();
          }

          return 1;
        }
      }
      if (msg->wParam == 'D')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->PlayListFind(false);
            HWND edt = GetDlgItem(g_mainwnd->Handle(), IDC_EDIT1);
            SetWindowText(edt, "");
            g_mainwnd->Search();
            SetFocus(edt);
          }

          return 1;
        }
      }
      if (msg->wParam == 'F')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->PlayListFind(true);
            HWND edt = GetDlgItem(g_mainwnd->Handle(), IDC_EDIT1);
            SetWindowText(edt, "");
            g_mainwnd->Find();
            SetFocus(edt);
          }

          return 1;
        }
      }
      if (msg->wParam == 'D')
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          (GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            HWND edt = GetDlgItem(g_mainwnd->Handle(), IDC_EDIT1);
            SendMessage(edt, EM_SETSEL, 0, -1);
            SetFocus(edt);
          }

          return 1;
        }
      }
      if (msg->wParam == 'K')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SetFocus(GetDlgItem(g_mainwnd->Handle(), IDC_TREE1));
          }

          return 1;
        }
      }
      if (msg->wParam == 'L')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->FocusPlayList();
          }

          return 1;
        }
      }
      if (msg->wParam == 'T')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->FocusTrack();
          }

          return 1;
        }
      }
      if (msg->wParam == 'T')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->ToggleTime();
          }

          return 1;
        }
      }
      if (msg->wParam == 'P')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_OPTIONS_PREFERENCES, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'Q')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_EXIT, 0);
          }

          return 1;
        }
      }
    }

    if (msg->message == WM_KEYUP || msg->message == WM_SYSKEYUP /* || msg->message == WM_CHAR */)
    {

    }
  }

  return 0;
}

void THA_RunMessageLoop()
{
#if defined(_WIN32)
  for (;;) // Justin Frankel in the loop
  {
    MSG msg = { 0, };
    int vvv = GetMessage(&msg, NULL, 0, 0);

    if (!vvv)
    {
      break;
    }

    if (vvv < 0)
    {
      Sleep(10);
      continue;
    }

    if (!msg.hwnd)
    {
      DispatchMessage(&msg);
      continue;
    }

    vvv = THA_ProcessMessage(&msg);

    if (vvv > 0)
    {
      continue;
    }

    if (g_mainwnd->Handle())
    {
      if (IsDialogMessage(g_mainwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_loadplwnd)
    {
      if (IsDialogMessage(g_loadplwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_changelogwnd)
    {
      if (IsDialogMessage(g_changelogwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_prefwnd)
    {
      if (IsDialogMessage(g_prefwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_licwnd)
    {
      if (IsDialogMessage(g_licwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_aboutwnd)
    {
      if (IsDialogMessage(g_aboutwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (IsDialogMessage(g_indexwnd, &msg))
    {
      continue;
    }


    HWND parent = NULL;
    HWND temp = msg.hwnd;

    do
    {
      if (GetClassLong(temp, GCW_ATOM) == (INT)32770)
      {
        parent = temp;

        if (!(GetWindowLong(temp, GWL_STYLE) &WS_CHILD))
        {
          break;  // not a child, exit
        }
      }
    }
    while (temp = GetParent(temp));

    if (parent && IsDialogMessage(parent, &msg))
    {
      continue;
    }

    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
#else
  for (;;)
  {
    MSG msg = { 0, };
    int x = THA_ProcessMessage(&msg);

    if (x == 0)
    {
      break;
    }
  }
#endif
}
