// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _THA_PLAYLIST_WND_H_
#define _THA_PLAYLIST_WND_H_

#include "thalia/definitions.h"

#include "WDL/wingui/wndsize.h"
#include "WDL/wdlstring.h"

class THA_SavePlayListWnd
{
public:
  THA_SavePlayListWnd();
  ~THA_SavePlayListWnd();

  HWND Handle() const { return m_hwnd; }
  static WDL_DLGRET SavePlayListWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  WDL_DLGRET SavePlayListWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;

  WDL_FastString m_strbuf;
};



class THA_LoadPlayListWnd
{
public:
  THA_LoadPlayListWnd();
  ~THA_LoadPlayListWnd();

  HWND Handle() const { return m_hwnd; }
  static WDL_DLGRET LoadPlayListWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  WDL_DLGRET LoadPlayListWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);
  void DatabaseCopy();
  void DatabaseOpenFileLocation();

  HWND m_hwnd;

  WDL_WndSizer m_resize;
  TV_INSERTSTRUCT m_tvinsert;
  HWND m_tree;
  HMENU m_playlist_menu;
  WDL_FastString m_strbuf;
  HWND m_list;
};



class THA_EditPlayListsWnd
{
public:
  THA_EditPlayListsWnd();
  ~THA_EditPlayListsWnd();

  HWND Handle() const { return m_hwnd; }

  void Rename();
  HWND GetRename() const;
  void RenameConfirm();
  void RenameAbort();
  void Delete();

  static WDL_DLGRET EditPlayListsWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  WDL_DLGRET EditPlayListsWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;

  WDL_WndSizer m_resize;

  HWND m_list;

  struct ColumnHeader
  {
    int id;
    const char *text;
    int width;
    int fmt;
    int sort_dir; // 1 ascending, -1 descending
    int sort_type; // 0 text, 1 numeric
  };

  WDL_TypedBuf<ColumnHeader> m_column_header;
  WDL_FastString m_strbuf;
  HWND m_edit;
  HMENU m_playlist_menu;
};

#endif // _THA_PLAYLIST_WND_H_
