// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _THA_MODULE_CREATION_H_
#define _THA_MODULE_CREATION_H_

#include "thalia/definitions.h"
#include "thalia/thalia_plugin.h"

THA_IFileInput *CreateFileInput(const char *filename);
THA_IFileTag *CreateFileTag(const char *filename);
THA_IFileTag *CreateEditFileTag(const char *filename);
THA_IFilePic *CreateFilePic(const char *filename);
THA_IAudioStreamer *CreateAudioStreamer();
THA_IAudioStreamerDevice *CreateAudioStreamerDevice(const char *name);
THA_IPitchShift *CreatePitchShift(const char *name);
THA_IFXProcessor *CreateFXProcessor();

void LoadPlugins();
void ReleasePlugins();

#endif // _THA_MODULE_CREATION_H_
