// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _THA_RENDER_SYSTEM_H_
#define _THA_RENDER_SYSTEM_H_

#include "thalia/definitions.h"
#include "thalia/plugin.h"
#include "thalia/track.h"

#include "WDL/mutex.h"
#include "WDL/heapbuf.h"
#include "WDL/wdlstring.h"
#include "WDL/ptrlist.h"

class THA_RenderSystem
{
public:
  THA_RenderSystem();
  ~THA_RenderSystem();

  void AddTrack(THA_Track *track);
  void DeleteAllTracks();

  void StartThread();
  void StopThread();
  bool IsRunning();
  bool IsActive();
  bool IsStreaming();

  const char *GetTime(bool remaining = false) const;
  void SetVolume(double vol) { m_vol = vol; }
  double GetVolume() const { return m_vol; }
  const char *GetStreamInfo() const;

  void AudioStreamerData(WDL_TypedBuf<SAM> *output, int frame_count, int channels);
private:
  static unsigned int WINAPI ThreadFunction(void *arg);
  int Run();

  struct ThreadDetails
  {
    unsigned int id;
    HANDLE thread;
  };

  WDL_TypedBuf<ThreadDetails> m_threads;
  bool m_killthread;
  WDL_Mutex m_mutex;
  bool m_running;

  WDL_PtrList<THA_Track> m_tracks;
  WDL_FastString m_time_elapsed;
  WDL_FastString m_time_remaining;
  double m_vol;
};

#endif // _THA_RENDER_SYSTEM_H_
