// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _THA_TRACK_H_
#define _THA_TRACK_H_

#include "thalia/definitions.h"
#include "thalia/buffer_queue.h"
#include "thalia/sample_format.h"
#include "thalia/plugin.h"

class THA_Track
{
public:
  THA_Track();
  ~THA_Track();

  bool Open(const char *filepath);

  bool IsDrained() const;
  bool WantMore() const;
  bool DoBuffering();
  bool IsStreaming() const;
  const char *GetStreamInfo() const;

  double GetLength() const { return m_length; }
  int GetChannels() const { return m_nch; }

  THA_BufferQueue m_bq;
private:
  WDL_TypedBuf<SAM> m_buffer;

  bool m_eof;
  int m_bqms;

  THA_IFileInput *m_input;

  bool m_stream;
  double m_length;
  int m_nch;
};

#endif // _THA_TRACK_H_
