#ifndef _THALIA_FLAC_ATTACHED_PICTURE_H_
#define _THALIA_FLAC_ATTACHED_PICTURE_H_

#include "thalia/thalia_plugin_public.h"

extern "C"
{
  #include <FLAC/all.h>
  #include <share/win_utf8_io.h>
  #include <share/windows_unicode_filenames.h>
}

#include "WDL/heapbuf.h"
#include "WDL/fileread.h"
#include "WDL/wdlstring.h"
#include "WDL/assocarray.h"

class THA_FlacAPIC : public THA_IFilePic
{
public:
  THA_FlacAPIC();
  ~THA_FlacAPIC();

  bool Open(const char *filename);

  int GetPicSize() const;
  void *GetPic() const;

private:
  WDL_HeapBuf m_apic;
  WDL_FastString m_fn;
  WDL_FileRead *m_file;
  WDL_StringKeyedArray<char *> m_metadata;
};

#endif // _THALIA_FLAC_ATTACHED_PICTURE_H_
