#ifndef _THA_FLAC_TAG_H_
#define _THA_FLAC_TAG_H_

#include "thalia/thalia_plugin_public.h"

extern "C"
{
  #include <FLAC/all.h>
  #include <share/win_utf8_io.h>
  #include <share/windows_unicode_filenames.h>
}

#include "WDL/wdlstring.h"
#include "WDL/fileread.h"
#include "WDL/assocarray.h"

class THA_FlacTag : public THA_IFileTag
{
public:
  THA_FlacTag();
  ~THA_FlacTag();

  bool Open(const char *filename);

  const char *GetType() const;

  const char *GetTitle() const;
  const char *GetArtist() const;
  const char *GetAlbum() const;
  const char *GetGenre() const;
  const char *GetTrack() const;
  const char *GetYear() const;
  const char *GetComment() const;

  void SetTitle(const char *val);
  void SetArtist(const char *val);
  void SetAlbum(const char *val);
  void SetGenre(const char *val);
  void SetTrack(const char *val);
  void SetYear(const char *val);
  void SetComment(const char *val);
  bool Save();

  WDL_INT64 GetFileSize() const;
  const char *GetFileName() const;
  const char *GetFilePath() const;
  const char *GetFileExtension() const;

private:
  WDL_FastString m_fn;
  WDL_FileRead *m_file;
  WDL_StringKeyedArray<char *> m_metadata;
};

#endif // _THA_FLAC_TAG_H_
