#if defined(_WIN32) && defined(_DEBUG)
#include <vld.h>
#endif

//#define ENABLE_THA_MP3_CONSOLE

#include "thalia/thalia_plugin_public.h"
#include "thalia_mp3/mp3_input.h"
#include "thalia_mp3/mp3_apic.h"
#include "thalia_mp3/mp3_tag.h"

#include "WDL/wdlcstring.h"

double (*THA_GetAudioDeviceSamplerate)();
void (*THA_GetDiskReadMode)(int *rmode, int *rbufsize, int *rnbufs);
void (*THA_GetResampleMode)(bool *interp, int *filtercnt,
  bool *sinc, int *sinc_size, int *sinc_interpsize);

static HINSTANCE flac_instance;
static HWND flac_main_hwnd;

THA_IFileInput *CreateFromType(const char *type)
{
  if (!strcmp(type, "MP3"))
  {
    return new THA_Mp3Input;
  }

  return NULL;
}

THA_IFileInput *CreateFromFile(const char *filename)
{
  if (!wdl_filename_cmp(WDL_get_fileext(filename), ".mp3"))
  {
    THA_Mp3Input *p = new THA_Mp3Input;

    if (p->Open(filename))
    {
      return p;
    }

    delete p;
  }

  return NULL;
}

struct THA_FileInputRegister mp3_reg_struct =
{
  CreateFromType,
  CreateFromFile,
};

THA_IFileTag *CreateMp3Tag(const char *filename)
{
  if (!wdl_filename_cmp(WDL_get_fileext(filename), ".mp3"))
  {
    THA_Mp3Tag *p = new THA_Mp3Tag;

    if (p && p->Open(filename))
    {
      return p;
    }
    else
    {
      delete p;
    }
  }

  return NULL;
}

THA_FileTagRegister mp3_tag_reg =
{
  &CreateMp3Tag
};

THA_IFilePic *CreateMp3APIC(const char *filename)
{
  if (!wdl_filename_cmp(WDL_get_fileext(filename), ".mp3"))
  {
    THA_Mp3APIC *p = new THA_Mp3APIC;

    if (p->Open(filename))
    {
      return p;
    }
    else
    {
      delete p;
    }
  }

  return NULL;
}

THA_FilePicRegister mp3_apic_reg =
{
  &CreateMp3APIC
};

extern "C"
{
  THA_PLUGIN_EXPORT int THA_PLUGIN_ENTRYPOINT(
    THA_PLUGIN_HINSTANCE instance, THA_PluginInfo *rec)
  {
#if defined(_WIN32) && defined(_DEBUG) && defined(ENABLE_THA_MP3_CONSOLE)
    // The first will use the console only if
    // the application is started by the command 
    // line. The second one will always enable
    // the console.
    //if (AttachConsole(ATTACH_PARENT_PROCESS))
    if (AttachConsole(ATTACH_PARENT_PROCESS) || AllocConsole())
    {
        freopen("CONOUT$", "w", stdout);
        freopen("CONOUT$", "w", stderr);
    }
#endif

    flac_instance = instance;

    if (rec)
    {
      if (rec->caller_version != THA_PLUGIN_VERSION || !rec->GetFunc)
      {
        return 0;
      }

      flac_main_hwnd = rec->hwnd_main;

      *((void **)&THA_GetAudioDeviceSamplerate) = rec->GetFunc("THA_GetAudioDeviceSamplerate");
      *((void **)&THA_GetDiskReadMode) = rec->GetFunc("THA_GetDiskReadMode");
      *((void **)&THA_GetResampleMode) = rec->GetFunc("THA_GetResampleMode");

      if (!rec->Register || !THA_GetAudioDeviceSamplerate || !THA_GetDiskReadMode ||
        !THA_GetResampleMode)
      {
        return 0;
      }

      rec->Register("input", &mp3_reg_struct);
      rec->Register("tag", &mp3_tag_reg);
      //rec->Register("apic", &mp3_apic_reg);

      return 1;
    }
    else
    {
      return 0;
    }
  }
}
