#include "thalia_mp3/mp3_tag.h"
#include "thalia_mp3/mp3_entry_point.h"

int ReadMediaTags(WDL_FileRead *fr, WDL_StringKeyedArray<char*> *metadata,
  WDL_INT64 *_fstart, WDL_INT64 *_fend);

THA_Mp3Tag::THA_Mp3Tag()
  : m_file(NULL)
  , m_metadata(false, WDL_StringKeyedArray<char *>::freecharptr)
{}

THA_Mp3Tag::~THA_Mp3Tag()
{
  if (m_file) delete m_file;
  m_metadata.DeleteAll();
}

bool THA_Mp3Tag::Open(const char *filename)
{
  m_fn.Set(filename);

  int rmode, rbufsize, rnbufs;
  THA_GetDiskReadMode(&rmode, &rbufsize, &rnbufs);
  m_file = new WDL_NEW WDL_FileRead(filename, rmode, rbufsize, rnbufs);

  if (!m_file || !m_file->IsOpen())
  {
    return false;
  }

  WDL_INT64 fstart = 0, fend = m_file->GetSize();
  ReadMediaTags(m_file, &m_metadata, &fstart, &fend);

  return true;
}

const char *THA_Mp3Tag::GetType() const
{
  return "MP3";
}

const char *THA_Mp3Tag::GetTitle() const
{
  return m_metadata.Get("ID3:TIT2", "");
}

const char *THA_Mp3Tag::GetArtist() const
{
  return m_metadata.Get("ID3:TPE1", "");
}

const char *THA_Mp3Tag::GetAlbum() const
{
  return m_metadata.Get("ID3:TALB", "");
}

const char *THA_Mp3Tag::GetGenre() const
{
  return m_metadata.Get("ID3:TCON", "");
}

const char *THA_Mp3Tag::GetTrack() const
{
  return m_metadata.Get("ID3:TRCK", "");
}

const char *THA_Mp3Tag::GetYear() const
{
  return m_metadata.Get("ID3:TYER", "");
}

const char *THA_Mp3Tag::GetComment() const
{
  return m_metadata.Get("ID3:COMM", "");
}

WDL_INT64 THA_Mp3Tag::GetFileSize() const
{
  return m_file->GetSize();
}

const char *THA_Mp3Tag::GetFileName() const
{
  return m_fn.get_filepart();
}

const char *THA_Mp3Tag::GetFilePath() const
{
  return m_fn.Get();
}

const char *THA_Mp3Tag::GetFileExtension() const
{
  return m_fn.get_fileext();
}

void THA_Mp3Tag::SetTitle(const char *val)
{}

void THA_Mp3Tag::SetArtist(const char *val)
{}

void THA_Mp3Tag::SetAlbum(const char *val)
{}

void THA_Mp3Tag::SetGenre(const char *val)
{}

void THA_Mp3Tag::SetTrack(const char *val)
{}

void THA_Mp3Tag::SetYear(const char *val)
{}

void THA_Mp3Tag::SetComment(const char *val)
{}

bool THA_Mp3Tag::Save()
{
  return false;
}
