// Copyright (c) 2020 Giorgos Vougioukas
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation; either version 2.1 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.

#ifndef _THALIA_TAGLIB_ATTACHED_PICTURE_H_
#define _THALIA_TAGLIB_ATTACHED_PICTURE_H_

#include "thalia/thalia_plugin_public.h"

#include <taglib.h>
#include <fileref.h>
#include <tag.h>
#include <tbytevector.h>
#include <tpropertymap.h>
#include <flacfile.h>
#include <mpegfile.h>
#include <oggfile.h>
#include <oggflacfile.h>
#include <vorbisfile.h>
#include <id3v2tag.h>
#include <id3v1tag.h>
#include <apetag.h>
#include <xiphcomment.h>
#include <flacpicture.h>
#include <attachedpictureframe.h>
#include <textidentificationframe.h>

#include "WDL/heapbuf.h"
#include "WDL/wdlstring.h"

class THA_GenericAPIC : public THA_IFilePic
{
public:
  THA_GenericAPIC();
  ~THA_GenericAPIC();

  bool Open(const char *filename);

  int GetPicSize() const;
  void *GetPic() const;

private:
  void ReadID3v2(TagLib::ID3v2::Tag *tag);
  void ReadXiphComment(TagLib::Ogg::XiphComment *tag);

  WDL_HeapBuf m_apic;
  WDL_FastString m_fn;
};

#endif // _THALIA_TAGLIB_ATTACHED_PICTURE_H_
