// Copyright (c) 2018 Giorgos Vougioukas
//
// This software is provided 'as-is', without any express or implied
// warranty.  In no event will the authors be held liable for any damages
// arising from the use of this software.
//
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you must not
//     claim that you wrote the original software. If you use this software
//     in a product, an acknowledgment in the product documentation would be
//     appreciated but is not required.
//  2. Altered source versions must be plainly marked as such, and must not be
//     misrepresented as being the original software.
//  3. This notice may not be removed or altered from any source distribution.

#include "thalia/thalia_plugin_public.h"
#include "thalia_taglib/taglib_apic.h"
#include "thalia_taglib/taglib_tag.h"

#include "WDL/wdlcstring.h"

#if defined(_WIN32) && defined(_DEBUG)
// Oops! Optional.
#include <vld.h>
#endif

static HINSTANCE tagger_instance;
static HWND tagger_main_hwnd;

THA_IFileTag *CreateGenericTag(const char *filename)
{
  if (!wdl_filename_cmp(WDL_get_fileext(filename), ".mp3") ||
    !wdl_filename_cmp(WDL_get_fileext(filename), ".flac") ||
    !wdl_filename_cmp(WDL_get_fileext(filename), ".ogg") ||
    !wdl_filename_cmp(WDL_get_fileext(filename), ".wv") ||
    !wdl_filename_cmp(WDL_get_fileext(filename), ".wav") ||
    !wdl_filename_cmp(WDL_get_fileext(filename), ".aiff") ||
    !wdl_filename_cmp(WDL_get_fileext(filename), ".opus"))
  {
    THA_GenericTag *p = new THA_GenericTag;

    if (p->Open(filename))
    {
      return p;
    }
    else
    {
      delete p;
    }
  }

  return NULL;
}

THA_FileTagRegister taglib_reg =
{
  &CreateGenericTag
};

THA_IFilePic *CreateGenericAPIC(const char *filename)
{
  if (!wdl_filename_cmp(WDL_get_fileext(filename), ".mp3") ||
    !wdl_filename_cmp(WDL_get_fileext(filename), ".flac") ||
    !wdl_filename_cmp(WDL_get_fileext(filename), ".ogg") ||
    !wdl_filename_cmp(WDL_get_fileext(filename), ".wv") ||
    !wdl_filename_cmp(WDL_get_fileext(filename), ".wav") ||
    !wdl_filename_cmp(WDL_get_fileext(filename), ".aiff") ||
    !wdl_filename_cmp(WDL_get_fileext(filename), ".opus"))
  {
    THA_GenericAPIC *p = new THA_GenericAPIC;

    if (p->Open(filename))
    {
      return p;
    }
    else
    {
      delete p;
    }
  }

  return NULL;
}

THA_FilePicRegister apic_reg =
{
  &CreateGenericAPIC
};

extern "C"
{
  THA_PLUGIN_EXPORT int THA_PLUGIN_ENTRYPOINT(
    THA_PLUGIN_HINSTANCE instance, THA_PluginInfo *rec)
  {
    tagger_instance = instance;

    if (rec)
    {
      if (rec->caller_version != THA_PLUGIN_VERSION || !rec->GetFunc)
      {
        return 0;
      }

      tagger_main_hwnd = rec->hwnd_main;

      if (!rec->Register)
      {
        return 0;
      }

      rec->Register("edit_tag", &taglib_reg);
      rec->Register("apic", &apic_reg);

      return 1;
    }
    else
    {
      return 0;
    }
  }
}
