// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#if defined(_WIN32) && defined(_DEBUG)
#include <vld.h>
#endif

//#define ENABLE_THA_VORBIS_CONSOLE

#include "thalia/thalia_plugin_public.h"
#include "thalia_vorbis/vorbis_input.h"
#include "thalia_vorbis/vorbis_apic.h"
#include "thalia_vorbis/vorbis_tag.h"

#include "WDL/wdlcstring.h"

double (*THA_GetAudioDeviceSamplerate)();
void (*THA_GetDiskReadMode)(int *rmode, int *rbufsize, int *rnbufs);
void (*THA_GetResampleMode)(bool *interp, int *filtercnt,
  bool *sinc, int *sinc_size, int *sinc_interpsize);

static HINSTANCE ogg_instance;
static HWND ogg_main_hwnd;

THA_IFileInput *CreateFromType(const char *type)
{
  if (!strcmp(type, "OGG"))
  {
    return new THA_VorbisInput;
  }

  return NULL;
}

THA_IFileInput *CreateFromFile(const char *filename)
{
  if (!wdl_filename_cmp(WDL_get_fileext(filename), ".ogg"))
  {
    THA_VorbisInput *p = new THA_VorbisInput;

    if (p->Open(filename))
    {
      return p;
    }

    delete p;
  }

  return NULL;
}

struct THA_FileInputRegister ogg_input_reg =
{
  CreateFromType,
  CreateFromFile,
};

THA_IFileTag *CreateVorbisTag(const char *filename)
{
  if (!wdl_filename_cmp(WDL_get_fileext(filename), ".ogg"))
  {
    THA_VorbisTag *p = new THA_VorbisTag;

    if (p && p->Open(filename))
    {
      return p;
    }
    else
    {
      delete p;
    }
  }

  return NULL;
}

THA_FileTagRegister ogg_tag_reg =
{
  &CreateVorbisTag
};

THA_IFilePic *CreateVorbisAPIC(const char *filename)
{
  if (!wdl_filename_cmp(WDL_get_fileext(filename), ".ogg"))
  {
    THA_VorbisAPIC *p = new THA_VorbisAPIC;

    if (p->Open(filename))
    {
      return p;
    }
    else
    {
      delete p;
    }
  }

  return NULL;
}

THA_FilePicRegister ogg_apic_reg =
{
  &CreateVorbisAPIC
};

extern "C"
{
  THA_PLUGIN_EXPORT int THA_PLUGIN_ENTRYPOINT(
    THA_PLUGIN_HINSTANCE instance, THA_PluginInfo *rec)
  {
#if defined(_WIN32) && defined(_DEBUG) && defined(ENABLE_THA_VORBIS_CONSOLE)
    // The first will use the console only if
    // the application is started by the command 
    // line. The second one will always enable
    // the console.
    //if (AttachConsole(ATTACH_PARENT_PROCESS))
    if (AttachConsole(ATTACH_PARENT_PROCESS) || AllocConsole())
    {
        freopen("CONOUT$", "w", stdout);
        freopen("CONOUT$", "w", stderr);
    }
#endif

    ogg_instance = instance;

    if (rec)
    {
      if (rec->caller_version != THA_PLUGIN_VERSION || !rec->GetFunc)
      {
        return 0;
      }

      ogg_main_hwnd = rec->hwnd_main;

      *((void **)&THA_GetAudioDeviceSamplerate) = rec->GetFunc("THA_GetAudioDeviceSamplerate");
      *((void **)&THA_GetDiskReadMode) = rec->GetFunc("THA_GetDiskReadMode");
      *((void **)&THA_GetResampleMode) = rec->GetFunc("THA_GetResampleMode");

      if (!rec->Register || !THA_GetAudioDeviceSamplerate || !THA_GetDiskReadMode ||
        !THA_GetResampleMode)
      {
        return 0;
      }

      rec->Register("input", &ogg_input_reg);
      rec->Register("tag", &ogg_tag_reg);
      //rec->Register("apic", &ogg_apic_reg);

      return 1;
    }
    else
    {
      return 0;
    }
  }
}
