#include "thalia_vorbis/vorbis_tag.h"
#include "thalia_vorbis/vorbis_entry_point.h"

#include "WDL/win32_utf8.h"

THA_VorbisTag::THA_VorbisTag()
  : m_file(NULL)
  , m_metadata(false, WDL_StringKeyedArray<char *>::freecharptr)
{}

THA_VorbisTag::~THA_VorbisTag()
{
  ov_clear(&m_vf);
  if (m_file) delete m_file;
  m_metadata.DeleteAll();
}

bool THA_VorbisTag::Open(const char *filename)
{
  m_fn.Set(filename);

  int rmode, rbufsize, rnbufs;
  THA_GetDiskReadMode(&rmode, &rbufsize, &rnbufs);
  m_file = new WDL_NEW WDL_FileRead(filename, rmode, rbufsize, rnbufs);

  if (!m_file || !m_file->IsOpen())
  {
    return false;
  }

  FILE *file = fopen(m_fn.Get(), "rb");
  if (ov_open_callbacks(file, &m_vf, NULL, 0, OV_CALLBACKS_NOCLOSE) < 0)
  {
    fclose(file);
    return false;
  }

  vorbis_comment *vc = m_vf.vc;

  if (vc)
  {
    for (int i = 0; i < vc->comments; i++)
    {
      m_strbuf.Set((const char *)vc->user_comments[i]);

      if (!strnicmp(m_strbuf.Get(), "TITLE=", 6))
      {
        m_strbuf.DeleteSub(0, 6);
        m_metadata.Insert("TITLE", strdup(m_strbuf.Get()));
      }
      else if (!strnicmp(m_strbuf.Get(), "ALBUM=", 6))
      {
        m_strbuf.DeleteSub(0, 6);
        m_metadata.Insert("ALBUM", strdup(m_strbuf.Get()));
      }
      else if (!strnicmp(m_strbuf.Get(), "TRACKNUMBER=", 12))
      {
        m_strbuf.DeleteSub(0, 12);
        m_metadata.Insert("TRACKNUMBER", strdup(m_strbuf.Get()));
      }
      else if (!strnicmp(m_strbuf.Get(), "ARTIST=", 7))
      {
        m_strbuf.DeleteSub(0, 7);
        m_metadata.Insert("ARTIST", strdup(m_strbuf.Get()));
      }
      else if (!strnicmp(m_strbuf.Get(), "DESCRIPTION=", 12))
      {
        m_strbuf.DeleteSub(0, 12);
        m_metadata.Insert("DESCRIPTION", strdup(m_strbuf.Get()));
      }
      else if (!strnicmp(m_strbuf.Get(), "GENRE=", 6))
      {
        m_strbuf.DeleteSub(0, 6);
        m_metadata.Insert("GENRE", strdup(m_strbuf.Get()));
      }
      else if (!strnicmp(m_strbuf.Get(), "DATE=", 5))
      {
        m_strbuf.DeleteSub(0, 5);
        m_metadata.Insert("DATE", strdup(m_strbuf.Get()));
      }
    }
  }

  fclose(file);
  return true;
}

const char *THA_VorbisTag::GetType() const
{
  return "OGG";
}

const char *THA_VorbisTag::GetTitle() const
{
  return m_metadata.Get("TITLE", "");
}

const char *THA_VorbisTag::GetArtist() const
{
  return m_metadata.Get("ARTIST", "");
}

const char *THA_VorbisTag::GetAlbum() const
{
  return m_metadata.Get("ALBUM", "");
}

const char *THA_VorbisTag::GetGenre() const
{
  return m_metadata.Get("GENRE", "");
}

const char *THA_VorbisTag::GetTrack() const
{
  return m_metadata.Get("TRACKNUMBER", "");
}

const char *THA_VorbisTag::GetYear() const
{
  return m_metadata.Get("DATE", "");
}

const char *THA_VorbisTag::GetComment() const
{
  return m_metadata.Get("DESCRIPTION", "");
}

WDL_INT64 THA_VorbisTag::GetFileSize() const
{
  return m_file->GetSize();
}

const char *THA_VorbisTag::GetFileName() const
{
  return m_fn.get_filepart();
}

const char *THA_VorbisTag::GetFilePath() const
{
  return m_fn.Get();
}

const char *THA_VorbisTag::GetFileExtension() const
{
  return m_fn.get_fileext();
}

void THA_VorbisTag::SetTitle(const char *val)
{}

void THA_VorbisTag::SetArtist(const char *val)
{}

void THA_VorbisTag::SetAlbum(const char *val)
{}

void THA_VorbisTag::SetGenre(const char *val)
{}

void THA_VorbisTag::SetTrack(const char *val)
{}

void THA_VorbisTag::SetYear(const char *val)
{}

void THA_VorbisTag::SetComment(const char *val)
{}

bool THA_VorbisTag::Save()
{
  return false;
}
