// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _THA_AUDIO_STREAMER_WASAPI_H_
#define _THA_AUDIO_STREAMER_WASAPI_H_

#include <windows.h>

#include <portaudio.h>
#include <pa_win_wasapi.h>
#include <pa_util.h>

#include "thalia/thalia_plugin.h"

#include "WDL/heapbuf.h"
#include "WDL/queue.h"
#include "WDL/wdlstring.h"

class THA_Wasapi : public THA_IAudioStreamer
{
public:
  THA_Wasapi();
  ~THA_Wasapi();

  bool Open();
  void Start(THA_AudioCallback callback);
  void Stop();
  void Close();
  bool IsRunning() const;
  double GetSampleRate() const;

private:
  static int pa_callback(const void *input, void *output, unsigned long frame_count,
    const PaStreamCallbackTimeInfo *time_info, PaStreamCallbackFlags status_flags,
    void *user_data);

  PaError m_error;
  PaStream *m_stream;
  bool m_running;

  THA_AudioCallback m_callback;

  int m_sample_fmt;
  int m_samplerate;
  int m_output_nch;
  int m_output_dev;

  bool m_exclusive;

  WDL_TypedBuf<SAM> m_buffer;
  WDL_HeapBuf m_pcm;
};

#endif // _THA_AUDIO_STREAMER_WASAPI_H_
