// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _THA_AUDIO_STREAMER_WASAPI_DEVICE_H_
#define _THA_AUDIO_STREAMER_WASAPI_DEVICE_H_

#include "thalia/thalia_plugin.h"

#include <portaudio.h>

#include "WDL/assocarray.h"

extern HINSTANCE waveout_instance;

class THA_WasapiDevice : public THA_IAudioStreamerDevice
{
public:
  THA_WasapiDevice();
  ~THA_WasapiDevice();

  void Scan();

  int GetDefaultInputDevice() const;
  int GetDefaultOutputDevice() const;

  //WDL_IntKeyedArray<const char *> input_dev;
  //WDL_IntKeyedArray<const char *> output_dev;

private:
  PaError m_error;

  int m_default_input_dev;
  int m_default_output_dev;

  PaHostApiTypeId m_host_api_id;
};

#endif // _THA_AUDIO_STREAMER_WASAPI_DEVICE_H_
