#include "thalia_waveform/waveform_apic.h"
#include "thalia_waveform/waveform_entry_point.h"

#include "WDL/wdl_base64.h"
#include "WDL/wdlutf8.h"
#include "WDL/metadata.h"

THA_WaveFormAPIC::THA_WaveFormAPIC()
  : m_file(NULL)
  , m_metadata(false, WDL_StringKeyedArray<char *>::freecharptr)
{}

THA_WaveFormAPIC::~THA_WaveFormAPIC()
{
  if (m_file) delete m_file;
}

bool THA_WaveFormAPIC::Open(const char *filename)
{
  WDL_ASSERT(filename != NULL);

  m_fn.Set(filename);

  //int rmode, rbufsize, rnbufs;
  //THA_GetDiskReadMode(&rmode, &rbufsize, &rnbufs);
  //m_file = new WDL_NEW WDL_FileRead(filename, rmode, rbufsize, rnbufs);

  //if (!m_file || !m_file->IsOpen())
  //{
  //  return false;
  //}

  return false;
}

int THA_WaveFormAPIC::GetPicSize() const
{
  return m_apic.GetSize();
}

void *THA_WaveFormAPIC::GetPic() const
{
  return m_apic.Get();
}
