// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _THA_WAVEFORM_ENTRY_POINT_H_
#define _THA_WAVEFORM_ENTRY_POINT_H_

#define ENABLE_SNDFILE_WINDOWS_PROTOTYPES 1
#include "third_party/libsndfile/sndfile.h"

extern double (*THA_GetAudioDeviceSamplerate)();
extern void (*THA_GetDiskReadMode)(int *rmode, int *rbufsize, int *rnbufs);
extern void (*THA_GetResampleMode)(bool *interp, int *filtercnt,
  bool *sinc, int *sinc_size, int *sinc_interpsize);

extern sf_count_t sf_filelength(void *user_data);
extern sf_count_t sf_seek(sf_count_t offset, int whence, void *user_data);
extern sf_count_t sf_read(void *ptr, sf_count_t count, void *user_data);
extern sf_count_t sf_write(const void *ptr, sf_count_t count, void *user_data);
extern sf_count_t sf_tell(void *user_data);

struct sndfile
{
  int (*close)(SNDFILE *sndfile);
  SNDFILE *(*open)(const char *path, int mode, SF_INFO *sfinfo);
  SNDFILE *(*wchar_open)(LPCWSTR wpath, int mode, SF_INFO *sfinfo);
  int (*set_string)(SNDFILE *sndfile, int str_type, const char* str);
  const char *(*get_string)(SNDFILE *sndfile, int str_type);
  sf_count_t (*readf_double)(SNDFILE *sndfile, double *ptr, sf_count_t frames);
  SNDFILE *(*open_virtual)(SF_VIRTUAL_IO *sfvirtual, int mode, SF_INFO *sfinfo, void *user_data);
};

extern sndfile sf;

#endif // _THA_WAVEFORM_ENTRY_POINT_H_
